-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Apr 22, 2025 at 07:16 PM
-- Server version: 10.4.32-MariaDB
-- PHP Version: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `car_dealer`
--

-- --------------------------------------------------------

--
-- Table structure for table `brands`
--

CREATE TABLE `brands` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `brands`
--

INSERT INTO `brands` (`id`, `name`) VALUES
(3, 'Audi'),
(1, 'BMW'),
(9, 'Ford'),
(6, 'Mazda'),
(4, 'Mercedes Benz'),
(7, 'Subaru'),
(5, 'Toyota');

-- --------------------------------------------------------

--
-- Table structure for table `cars`
--

CREATE TABLE `cars` (
  `id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `model_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `year` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `mileage` int(11) DEFAULT NULL,
  `fuel_type` enum('Petrol','Diesel','Electric','Hybrid') NOT NULL,
  `transmission` enum('Manual','Automatic','CVT') NOT NULL,
  `drive_terrain` varchar(50) DEFAULT NULL,
  `condition_type` enum('New','Used') NOT NULL,
  `body_type` varchar(50) DEFAULT NULL,
  `steering` varchar(20) DEFAULT NULL,
  `displacement` int(11) DEFAULT NULL,
  `model_code` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `features` text DEFAULT NULL,
  `main_image` varchar(255) DEFAULT NULL,
  `status` enum('Available','Sold','Reserved') DEFAULT 'Available',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `cars`
--

INSERT INTO `cars` (`id`, `brand_id`, `model_id`, `title`, `year`, `price`, `mileage`, `fuel_type`, `transmission`, `drive_terrain`, `condition_type`, `body_type`, `steering`, `displacement`, `model_code`, `description`, `features`, `main_image`, `status`, `created_at`) VALUES
(2, 1, 15, 'BMW M3', 2016, 86000000.00, 28669, 'Petrol', 'Manual', 'FWD', 'New', 'Sedan', 'Left', 3000, 'F80', 'The BMW M3 is a high-performance version of the BMW 3 Series, developed by BMW&#039;s in-house motorsport division, BMW M GmbH. M3 models have been produced for every generation of 3 Series since the E30 M3 was introduced in 1986.\r\nThe initial model was available in a coupé body style, with a convertible body style made available soon after.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags', 'uploads/cars/67b5c18a5524f_Mattgrauer-Frozen-BMW-M3-F80-19-Zoll-V-FF-103-N4SM-Tuning-1.jpg', 'Available', '2025-02-19 11:51:25'),
(3, 1, 16, 'BMW M4', 2018, 99999999.99, 79574, 'Petrol', 'Automatic', 'FWD', 'New', 'Sedan', 'Left', 3000, 'F80', 'The BMW M4 is a high-performance version of the BMW 4 Series automobile developed by BMW&#039;s motorsport division, BMW M, that has been built since 2014. As part of the renumbering that splits the coupé and convertible variants of the 3 Series into the 4 Series, the M4 replaced those variants of the BMW M3.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags', 'uploads/cars/67b5c75b69d5f_HD-wallpaper-bmw-m3-2018-front-view-luxury-tuning-new-blue-m3-f80-tuning-m3-german-sports-cars-bmw.jpg', 'Available', '2025-02-19 11:58:23'),
(4, 1, 18, 'BMW M2', 2017, 8090.00, 28669, 'Petrol', 'Manual', 'FWD', 'Used', 'Sedan', 'Left', 3000, 'F80', 'The BMW M2 is a high-performance version of the BMW 2 Series automobile developed by BMW&#039;s motorsport division, BMW M GmbH. As the 2 Series replaced the 1 Series coupé and convertible models, the first-generation M2 was marketed as the most basic M model in the range.\r\nThe first-generation M2 used the F8x chassis from the M3/M4, codenamed F87 and featured the BMW N55 series engine, while its successors, the M2 Competition and M2 CS, featured a twin-turbocharged engine developed by BMW M GmbH (S55 engine).\r\n\r\n.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags', 'uploads/cars/67b5c80165def_55b17721-bmw-m3-individual-3.jpg', 'Available', '2025-02-19 12:01:26'),
(5, 4, 11, 'Mercedes Benz C 400', 2018, 86000000.00, 79574, 'Petrol', 'Automatic', 'AWD', 'Used', 'Sedan', 'Left', 3000, 'C400', 'The Mercedes-Benz GLE, formerly Mercedes-Benz M-Class (designated with the &quot;ML&quot; nomenclature), is a mid-size luxury SUV produced by the German manufacturer Mercedes-Benz since 1997. In terms of size, it is slotted in between the smaller GLC and the larger GLS, the latter with which it shares platforms.\r\n\r\nThe first-generation M-Class, designated with the model code W163, is a body-on-frame SUV and was produced until 2004. The second-generation M-Class (W164) moved to a unibody platform while sharing most components with the GL-Class, which sports a longer body to accommodate third-row seating.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags', 'uploads/cars/67b7314d9a80d_Mercedes-C63s-Matte-Grey-1-1140x700.jpg', 'Available', '2025-02-20 13:42:49'),
(6, 5, 20, 'Toyota Camry', 2018, 22000.00, 79574, 'Petrol', 'Automatic', 'FWD', 'Used', 'Hatchback', 'Right', 2000, 'Camry', 'The Toyota Camry (; Japanese: トヨタ・カムリ Toyota Kamuri) is an automobile sold internationally by the Japanese auto manufacturer Toyota since 1982, spanning multiple generations. Originally compact in size (narrow-body), the Camry has grown since the 1990s to fit the mid-size classification (wide-body)—although the two widths co-existed in that decade. Since the release of the wide-bodied versions, Camry has been extolled by Toyota as the firm&#039;s second &quot;world car&quot; after the Corolla.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags\r\nCruise Control\r\nCD Player\r\nMP3 Player\r\nUSB Port\r\nBluetooth\r\nAirbags', 'uploads/cars/67b7341d69c9a_20241118123511_Untitled design _54_.jpg', 'Available', '2025-02-20 13:59:27'),
(7, 5, 24, 'Toyota Land Cruiser Prado', 2019, 86000000.00, 28669, 'Petrol', 'Automatic', '4WD', 'Used', 'SUV', 'Left', 2500, 'prado', 'The Toyota Land Cruiser Prado (Japanese: トヨタ・ランドクルーザープラド, Hepburn: Toyota Rando-Kurūzā Purado) is a full-size four-wheel drive vehicle in the Land Cruiser range produced by the Japanese automaker Toyota as a &quot;light-duty&quot; variation in the range.\r\nThe Prado may also be referred to as Land Cruiser LC70, LC90, LC120, LC150 and LC250 depending on the platform. In some markets, it is known simply as the Toyota Prado or the Toyota Land Cruiser.\r\nUp until the J150 model, the Prado was not part of the Land Cruiser range in North America; the rebadged Lexus GX occupied the Prado&#039;s position in luxury trim. The Prado was then introduced there in 2023 and marketed simply as the &quot;Land Cruiser&quot;.\r\nThe Prado has a ladder frame chassis, two-speed transfer boxes and rear beam axles.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags\r\nCruise Control\r\nCD Player\r\nMP3 Player\r\nUSB Port\r\nBluetooth\r\nAirbags', 'uploads/cars/67b736756ad4e_images (8).jpeg', 'Available', '2025-02-20 14:04:50'),
(8, 7, 29, 'Subaru WRX STI', 2018, 5000.00, 70492, 'Petrol', 'Manual', 'AWD', 'Used', 'Sedan', 'Right', 2500, 'GC8', 'The Subaru WRX STI is a variant of the Subaru WRX sedan produced by in-house tuning company Subaru Tecnica International between 2004 and 2021. It succeeded the Subaru Impreza WRX STI. Production of the WRX STI concluded after its first generation, there are currently no plans for a VB WRX STI.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags\r\nCruise Control\r\nCD Player\r\nMP3 Player\r\nUSB Port\r\nBluetooth\r\nAirbags', 'uploads/cars/67b737970920a_images (9).jpeg', 'Available', '2025-02-20 14:11:50'),
(9, 3, 37, 'Audi A3', 2026, 8000.00, 28669, 'Petrol', 'CVT', 'FWD', 'Used', 'Sedan', 'Left', 2000, 'A', 'The Audi A3 is a small family car (C-segment) manufactured and marketed by the German automaker Audi AG since September 1996, currently in its fourth generation.\r\nThe first two generations of the Audi A3 were based on the Volkswagen Group A platform, while the third and fourth generations use the Volkswagen Group MQB platform.\r\n\r\n.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags\r\nCruise Control\r\nCD Player\r\nMP3 Player\r\nUSB Port\r\nBluetooth\r\nAirbags', 'uploads/cars/67bb8a8e26ef5_filters_quality(80).webp', 'Available', '2025-02-23 20:52:35'),
(10, 3, 38, 'Audi R8', 2018, 30000.00, 28669, 'Petrol', 'Automatic', 'AWD', 'Used', 'Coupe', 'Left', 4500, 'R8', 'The Audi R8 is a mid-engine, 2-seater sports car, which uses Audi&#039;s trademark quattro permanent all-wheel drive system. It was introduced by the German car manufacturer Audi AG in 2006. Production ended in the first quarter of 2024.\r\nThe car is exclusively designed, developed, and manufactured by Audi AG&#039;s private subsidiary company manufacturing high performance automotive parts, Audi Sport GmbH (formerly quattro GmbH), and is based on the Lamborghini Gallardo and presently the Huracán platform.', 'all-wheel drive\r\nPower Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags\r\nCruise Control\r\nCD Player\r\nMP3 Player\r\nUSB Port\r\nBluetooth\r\nAirbags', 'uploads/cars/67bb8bac0c25a_2017_audi_r8-v10-plus-coupe_2017_audi_r8-v10-plus-coupe_c4ed2440-df88-4447-8b9d-64aefbe3f891-dAPAFL-33569-33570-scaled.webp', 'Available', '2025-02-23 20:57:28'),
(11, 3, 36, 'Audi RS 6', 2017, 12000.00, 1653, 'Petrol', 'Automatic', 'AWD', 'Used', 'Coupe', 'Right', 4000, 'RS6', 'The Audi RS 6 is a high-performance variant of the Audi A6 range, produced by the high-performance subsidiary company Audi Sport GmbH, for its parent company Audi AG, a subsidiary of the Volkswagen Group, from 2002 onwards.\r\n\r\nThe first and second versions of the RS 6 were offered in both Avant and saloon forms. The third and fourth generations are only offered as an Avant.', 'Power Windows\r\nPower Steering\r\nAir Conditioning\r\nAnti-lock Braking System (ABS)\r\nDual Airbags\r\nCruise Control\r\nCD Player\r\nMP3 Player\r\nUSB Port\r\nBluetooth\r\nAirbags', 'uploads/cars/67bb8c52933b9_filters_quality(80).webp', 'Available', '2025-02-23 21:00:13');

-- --------------------------------------------------------

--
-- Table structure for table `car_comparisons`
--

CREATE TABLE `car_comparisons` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `car_ids` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `car_images`
--

CREATE TABLE `car_images` (
  `id` int(11) NOT NULL,
  `car_id` int(11) DEFAULT NULL,
  `image_path` varchar(255) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `car_images`
--

INSERT INTO `car_images` (`id`, `car_id`, `image_path`) VALUES
(4, 2, 'uploads/cars/67b5c19ee344a_download.jpeg'),
(5, 2, 'uploads/cars/67b5c1a691ec0_HD-wallpaper-bmw-m3-2018-front-view-luxury-tuning-new-blue-m3-f80-tuning-m3-german-sports-cars-bmw.jpg'),
(6, 3, '/uploads/cars/67b5c75b6a4aa_55b17721-bmw-m3-individual-3.jpg'),
(7, 3, '/uploads/cars/67b5c75d694cc_Atlantis-Blue-BMW-M3-.jpg'),
(8, 4, 'uploads/cars/67b5c80f761f9_HD-wallpaper-bmw-m3-2018-front-view-luxury-tuning-new-blue-m3-f80-tuning-m3-german-sports-cars-bmw.jpg'),
(9, 4, 'uploads/cars/67b5c80f7697f_Atlantis-Blue-BMW-M3-.jpg'),
(10, 4, 'uploads/cars/67b5c81140cdf_Mattgrauer-Frozen-BMW-M3-F80-19-Zoll-V-FF-103-N4SM-Tuning-1.jpg'),
(11, 5, 'uploads/cars/67b7314fe6845_Mercedes-C63s-Matte-Grey-25.jpg'),
(12, 6, 'uploads/cars/67b7341f857ae_2024_Toyota_GR_Corolla_Circuit_Edition,_front_left,_06-08-2024.jpg'),
(13, 7, 'uploads/cars/67b736756b5c1_2024landcruiser-006-qb9v.jpg'),
(14, 7, 'uploads/cars/67b7367766325_2025-toyota-4runner-trdpro-101-jpg-6615617db7e4d.jpg'),
(15, 7, 'uploads/cars/67b7367766aac_new-toyota-land-cruiser-prado-top-things-to-know-4.webp'),
(16, 7, 'uploads/cars/67b73679d7fa2_INKAS-Armored-2024-Toyota-Land-Cruiser-Prado-16.webp'),
(17, 7, 'uploads/cars/67b73679d8558_2024-toyota-land-cruiser-prado-002-tuqa.jpg'),
(18, 8, 'uploads/cars/67b7379709a44_2025-subaru-wrx-ts-112-6787e1bd71513.JPG'),
(19, 8, 'uploads/cars/67b737992d3f2_pexels-garvin-st-villier-719266-3778763.jpg'),
(20, 9, 'uploads/cars/67bb8a907f636_30f74494dc37492882eeeada7c85190c.webp'),
(21, 10, 'uploads/cars/67bb8bac0cbbb_1 Audi R8 GT review.jpg'),
(22, 11, 'uploads/cars/67bb8c5293d60_30f74494dc37492882eeeada7c85190c.webp');

-- --------------------------------------------------------

--
-- Table structure for table `contact_messages`
--

CREATE TABLE `contact_messages` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(100) NOT NULL,
  `subject` varchar(200) NOT NULL,
  `message` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('New','Read','Replied') DEFAULT 'New'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `email_notifications`
--

CREATE TABLE `email_notifications` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `type` enum('test_drive','inquiry','status_update','newsletter') NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` text NOT NULL,
  `status` enum('pending','sent','failed') DEFAULT 'pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `sent_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `favorites`
--

CREATE TABLE `favorites` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `car_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `favorites`
--

INSERT INTO `favorites` (`id`, `user_id`, `car_id`, `created_at`) VALUES
(1, 1, 6, '2025-02-20 14:53:57'),
(3, 1, 5, '2025-02-20 21:12:36'),
(6, 1, 3, '2025-02-23 13:11:03');

-- --------------------------------------------------------

--
-- Table structure for table `inquiries`
--

CREATE TABLE `inquiries` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(100) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `car_id` int(11) DEFAULT NULL,
  `message` text NOT NULL,
  `status` enum('New','In Progress','Resolved') DEFAULT 'New',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `inquiries`
--

INSERT INTO `inquiries` (`id`, `user_id`, `name`, `email`, `phone`, `car_id`, `message`, `status`, `created_at`) VALUES
(29, 1, 'Raisy Clutch', 'admin@car.com', '0726127811', 3, 'kjgkjjgik', 'New', '2025-02-23 18:40:43'),
(31, 1, 'Raisy Clutch', 'admin@car.com', '0726127811', 3, 'wetwetwe', 'New', '2025-02-23 19:29:00');

-- --------------------------------------------------------

--
-- Table structure for table `models`
--

CREATE TABLE `models` (
  `id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `name` varchar(50) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `models`
--

INSERT INTO `models` (`id`, `brand_id`, `name`) VALUES
(3, 1, '1 Series'),
(1, 1, '3 Series'),
(18, 1, 'M2'),
(15, 1, 'M3'),
(16, 1, 'M4'),
(17, 1, 'M5'),
(19, 1, 'M8'),
(4, 1, 'x1'),
(5, 1, 'x2'),
(6, 1, 'x3'),
(7, 1, 'x4'),
(8, 1, 'x5'),
(9, 1, 'x6'),
(10, 1, 'x7'),
(37, 3, 'A3'),
(32, 3, 'Q8'),
(38, 3, 'R8'),
(35, 3, 'RS3'),
(36, 3, 'RS7'),
(33, 3, 'RSQ8'),
(34, 3, 'SQ8'),
(11, 4, 'C - Class'),
(12, 4, 'E - Class'),
(13, 4, 'G - Class'),
(20, 5, 'Camry'),
(21, 5, 'Cienta'),
(24, 5, 'Land cruiser Prado'),
(23, 5, 'Prado'),
(22, 5, 'RAV4'),
(31, 7, 'Forester XT'),
(30, 7, 'Impreza'),
(29, 7, 'Impreza WRX STI'),
(25, 7, 'WRX STI');

-- --------------------------------------------------------

--
-- Table structure for table `test_drives`
--

CREATE TABLE `test_drives` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `car_id` int(11) DEFAULT NULL,
  `preferred_date` date NOT NULL,
  `preferred_time` time NOT NULL,
  `status` enum('Pending','Approved','Rejected','Completed') DEFAULT 'Pending',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `is_admin` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `email`, `password`, `first_name`, `last_name`, `phone`, `is_admin`, `created_at`) VALUES
(1, 'admin', 'admin@car.com', '$2a$12$4ObL5iTDt2OueAt1dg3dY.XWx9l70KP81TwIDwUAuLGiohfh054WS', 'Raisy', 'Clutch', '0726127811', 1, '2025-02-18 18:47:44');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `brands`
--
ALTER TABLE `brands`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `name` (`name`);

--
-- Indexes for table `cars`
--
ALTER TABLE `cars`
  ADD PRIMARY KEY (`id`),
  ADD KEY `brand_id` (`brand_id`),
  ADD KEY `model_id` (`model_id`);

--
-- Indexes for table `car_comparisons`
--
ALTER TABLE `car_comparisons`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `car_images`
--
ALTER TABLE `car_images`
  ADD PRIMARY KEY (`id`),
  ADD KEY `car_id` (`car_id`);

--
-- Indexes for table `contact_messages`
--
ALTER TABLE `contact_messages`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `email_notifications`
--
ALTER TABLE `email_notifications`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`);

--
-- Indexes for table `favorites`
--
ALTER TABLE `favorites`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_favorite` (`user_id`,`car_id`),
  ADD KEY `car_id` (`car_id`);

--
-- Indexes for table `inquiries`
--
ALTER TABLE `inquiries`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `car_id` (`car_id`);

--
-- Indexes for table `models`
--
ALTER TABLE `models`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_model_per_brand` (`brand_id`,`name`);

--
-- Indexes for table `test_drives`
--
ALTER TABLE `test_drives`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `car_id` (`car_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `brands`
--
ALTER TABLE `brands`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `cars`
--
ALTER TABLE `cars`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT for table `car_comparisons`
--
ALTER TABLE `car_comparisons`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `car_images`
--
ALTER TABLE `car_images`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=23;

--
-- AUTO_INCREMENT for table `contact_messages`
--
ALTER TABLE `contact_messages`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `email_notifications`
--
ALTER TABLE `email_notifications`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `favorites`
--
ALTER TABLE `favorites`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `inquiries`
--
ALTER TABLE `inquiries`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- AUTO_INCREMENT for table `models`
--
ALTER TABLE `models`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=39;

--
-- AUTO_INCREMENT for table `test_drives`
--
ALTER TABLE `test_drives`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `cars`
--
ALTER TABLE `cars`
  ADD CONSTRAINT `cars_ibfk_1` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`),
  ADD CONSTRAINT `cars_ibfk_2` FOREIGN KEY (`model_id`) REFERENCES `models` (`id`);

--
-- Constraints for table `car_comparisons`
--
ALTER TABLE `car_comparisons`
  ADD CONSTRAINT `car_comparisons_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `car_images`
--
ALTER TABLE `car_images`
  ADD CONSTRAINT `car_images_ibfk_1` FOREIGN KEY (`car_id`) REFERENCES `cars` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `email_notifications`
--
ALTER TABLE `email_notifications`
  ADD CONSTRAINT `email_notifications_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `favorites`
--
ALTER TABLE `favorites`
  ADD CONSTRAINT `favorites_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `favorites_ibfk_2` FOREIGN KEY (`car_id`) REFERENCES `cars` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `inquiries`
--
ALTER TABLE `inquiries`
  ADD CONSTRAINT `inquiries_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  ADD CONSTRAINT `inquiries_ibfk_2` FOREIGN KEY (`car_id`) REFERENCES `cars` (`id`) ON DELETE SET NULL;

--
-- Constraints for table `models`
--
ALTER TABLE `models`
  ADD CONSTRAINT `models_ibfk_1` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `test_drives`
--
ALTER TABLE `test_drives`
  ADD CONSTRAINT `test_drives_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `test_drives_ibfk_2` FOREIGN KEY (`car_id`) REFERENCES `cars` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
